﻿# Script to disable Actifile on a server
#
# Step 1: Stop the Actifile Agents
Stop-Service "Actifile Updater"
Stop-Service "Actifile Agent"

# Note - if the Actifile Agent fails to stop even after a few minutes - killing the process almost always works 
# Stop-Process -Name AFAgentService -Force 

# Step 2: Set the service startup type to manual so it won't resatrt upon reboot
Set-Service -Name "Actifile Agent" -StartupType Manual
Set-Service -Name "Actifile Updater" -StartupType Manual

# Step 3: Unload and delete the filter driver
fltmc unload EaseFilter
remove-item -Path $Env:WinDir\System32\drivers\EaseFlt.sys -Force

# Step 4: Print the list of filters to verify removal of the driver
fltmc filters