﻿
# Actifile Powershell Uninstall Script for RMM

# Append messages and errors to installation top the following log file... 
$DebugLog = Join-Path $Env:TMP ActifileUninstall.log

function Get-TimeStamp {
    return "[{0:yyyy/MM/dd} {0:HH:mm:ss}]" -f (Get-Date)
}

function LogMessage ($msg) {
    Add-Content $DebugLog "$(Get-TimeStamp) $msg"
    Write-Host "$(Get-TimeStamp) $msg"
}

function CheckAdmin {
    $oIdent= [Security.Principal.WindowsIdentity]::GetCurrent()
    $oPrincipal = New-Object Security.Principal.WindowsPrincipal($oIdent)
    if(!$oPrincipal.IsInRole([Security.Principal.WindowsBuiltInRole]::Administrator )){
        $err = "Please start script with Administrator rights - Quitting!"
        LogMessage $err
        throw $ScriptFailed + " " + $err
        exit 1
    }
}


# Check if product already installed 
function Check-Actifile-Installed {
    $ProductRegKey = "HKLM:\SOFTWARE\Wow6432Node\Microsoft\Windows\CurrentVersion\Uninstall\`{0D13F554-E542-4590-AACB-AA60CAE75A64`}"
    if (! (Test-Path $ProductRegKey)){
        $err = "Product Not Installed - Quitting!"
        LogMessage $err
        throw $ScriptFailed + " " + $err
    } else {
        LogMessage "Actifile installed - continuing..." 
    }
} 

# Create the command line arguments and install Actifile
function Uninstall-Actifile {
	$vPackage = Get-WmiObject Win32_Product -Filter "Name='Actifile Agent'"
	LogMessage "Now Uninstalling: $vPackage"
	$vPackage.Uninstall()
}

try {
    LogMessage "Actifile Uninstallation Script"
    LogMessage "v0.10" 

    CheckAdmin
	Check-Actifile-Installed
	
	# Step 1: Stop the Actifile Agents
	LogMessage "Stopping Actifile Services"
	Stop-Service "Actifile Updater"
	Stop-Service "Actifile Agent"

	# Note - if the Actifile Agent fails to stop even after a few minutes - killing the process almost always works 
	# Stop-Process -Name AFAgentService -Force 

	Stop-Process -Name AFAgentServiceManager -Force

	# Step 2: Set the service startup type to manual so it won't resatrt upon reboot
	Set-Service -Name "Actifile Agent" -StartupType Manual
	Set-Service -Name "Actifile Updater" -StartupType Manual

	fltmc unload Actifile
	remove-item -Path $Env:WinDir\System32\drivers\Actifile.sys -Force

    Uninstall-Actifile
}

catch {
    $ErrorMessage = $_.Exception.Message
    LogMessage $ErrorMessage
    exit 1
}